jQuery(function($){
	
	$('#id003Cargo_filter_table').rup_combo({
		source : "/ab03bRERAWar/ab03b03t00/comboCargosTodos",
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		width: 150,
		rowStriping : true,
		inputText:true,
		ordered:true,
		blank:""
	});
	
	if(esUsuarioDelegacion){
		$('#id003Cargo_detail_table').rup_combo({
			source : "/ab03bRERAWar/ab03b03t00/comboCargosDelegTec",
			sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
			width: 155,
			rowStriping : true,
			inputText:true,
			ordered:true
		});
	}else{
		$('#id003Cargo_detail_table').rup_combo({
			source : "/ab03bRERAWar/ab03b03t00/comboCargos",
			sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
			width: 155,
			rowStriping : true,
			inputText:true,
			ordered:true
		});
	}
	
	
	if($("#idProv004_filter_table").length > 0){
		$("#idProv004_filter_table").rup_combo({
			source: "/ab03bRERAWar/ab03bNora/comboProvinciaLakua",
			sourceParam:{
				label:"ds_o",
				value:"id"
			},
			ordered:true,
			style:"dropdown",
			width:150, 
			blank:""
		});
	}
	
	if($("#idProv004_detail_table").length > 0){
		$("#idProv004_detail_table").rup_combo({
			source: "/ab03bRERAWar/ab03bNora/comboProvinciaLakua",
			sourceParam:{
				label:"ds_o",
				value:"id"
			},
			ordered:true,
			style:"dropdown",
			width:300, 
			blank:""
		});
	}
	
	$("#tipoDoc044_filter_table").rup_combo({
		source: "/ab03bRERAWar/ab03b44t00/comboTipoDoc",
		sourceParam:{
			label:"ds_o",
			value:"id"
		},
		ordered:true,
		style:"dropdown",
		width:150, 
		blank:""
	});
	
	$("#tipoDoc044_detail_table").rup_combo({
		source: "/ab03bRERAWar/ab03b44t00/comboTipoDoc",
		sourceParam:{
			label:"ds_o",
			value:"id"
		},
		ordered:true,
		style:"dropdown",
		width:155, 
		blank:""
	});
	
	var plugins;
	if(esUsuarioModificacion){
		plugins =[
					"formEdit",
		        	"feedback",
					"toolbar",
		        	"contextMenu",
		        	"fluid",
		        	"filter"
		         ];
	} else {
		plugins =[
		        	"feedback",
		        	"fluid",
		        	"filter"
		         ];
	}
	
	$("#Firmantes").rup_table({
		url: "../ab03b04t00",
		colNames: [
			$.rup.i18n.app.mantenimientos.id,
			$.rup.i18n.app.mantenimientos.cargo,
			$.rup.i18n.app.mantenimientos.nombre,
			$.rup.i18n.app.mantenimientos.apellido1,
			$.rup.i18n.app.mantenimientos.apellido2,
			$.rup.i18n.app.mantenimientos.tipoDoc,
			$.rup.i18n.app.mantenimientos.nif,
			$.rup.i18n.app.mantenimientos.provincia,
			$.rup.i18n.app.mantenimientos.buzon,
			$.rup.i18n.app.mantenimientos.usuario,
			$.rup.i18n.app.mantenimientos.fecVigenciaDesde,
			$.rup.i18n.app.mantenimientos.fecVigenciaHasta
		],
		colModel: [
			{ 	name: "id004", 
			 	label: "id004",
				align: "center", 
				width: 55, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "desc003"+$.rup_utils.capitalizedLang(), 
				label: "id003Cargo", 
				align: "", 
				width: 110, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "nombre004", 
			 	label: "nombre004",
				align: "", 
				width: 100, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "apel1004", 
			 	label: "apel1004",
				align: "", 
				width: 120, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "apel2004", 
				label: "apel2004",
				align: "", 
				width: 120, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "desc"+$.rup_utils.capitalizedLang()+"044", 
			 	label: "tipoDoc044",
				align: "center", 
				width: 107, 
				editable: false, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "nifFirmante004", 
				label: "nifFirmante004",
				align: "center", 
				width: 90, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "provDo", 
			 	label: "provDo",
				align: "", 
				width: 100, 
				editable: false, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "buzon004", 
			 	label: "buzon004",
				align: "", 
				width: 85, 
				editable: false, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "usuario004", 
			 	label: "usuario004",
				align: "", 
				width: 85, 
				editable: false, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "fVigenciaDesde004String", 
			 	label: "fVigenciaDesde004String",
			 	index : "fVigenciaDesde004",
				align: "center", 
				width: 110, 
				editable: true, 
				ruptype: "datepicker", 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "fVigenciaHasta004String", 
			 	label: "fVigenciaHasta004String",
			 	index : "fVigenciaHasta004",
				align: "center", 
				width: 110, 
				editable: true, 
				ruptype: "datepicker", 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			}
	   ],
	   model:"Ab03b04t00",
	   usePlugins: plugins,
	   core: {
			showOperations: {
				'delete': false
			}},
	   primaryKey: "id004",
	   sortname: "id004",
	   sortorder: "asc",
	   loadOnStartUp: true,
	   feedback:{
		   config:{
			   block: false
		   }
	   },
	   formEdit:{
	       	detailForm: "#Firmantes_detail_div",
			fillDataMethod: "clientSide",
	        	validate:{ 
	   			rules:{
	   				"id004":{
						required: false,
						digits:true
	   				},
	   				"ab03b03t00.id003Cargo":{
						required: true
	   				},
	   				"nombre004":{
						required: true,
						maxlength: 150
	   				},
	   				"apel1004":{
						required: true,
						maxlength: 150
	   				},
	   				"apel2004":{
						maxlength: 150
	   				},
	   				"tipoDoc044": {
	   					required: true
	   				},
	   				"nifFirmante004": {
	   					required: true,
	   					tipoDocumento: true,
	   					maxlength: 150
	   				},
	   				"idProv004": {
	   					required: true
	   				},
	   				"usuario004": {
	   					maxlength: 20
	   				},
	   				"buzon004": {
	   					maxlength: 15
	   				},
					"fVigenciaHasta004String":{
						required: true,
						date: true,
						validacionFechasDetalle:true,
						validacionDelegado:true
						
					},
					"fVigenciaDesde004String":{
						required: true,
						date: true
					}
	   			}
	   		},
	   		addEditOptions:{
	   			reloadAfterSubmit:true
	   		}
	       }
	});
	
	$("#Firmantes_filter_form").rup_validate({
		feedback:$("#Firmantes_feedback"),
		liveCheckingErrors: false,
		rules:{
			"id004":{digits:true},
			'fVigenciaDesde004String': { date: true, validacionFechas:true },
			'fVigenciaHasta004String': { date: true, validacionFechas:true }
		}
	});	
	
	
	$("#Firmantes").on("rupTable_beforeFilter",
		function(){
		if(ab03bUtils.form.validate($("#Firmantes_filter_form"))){	
				return true;
			} else {
				return false;
			}
		}
	);	
});

$("#fVigenciaDesde004String_filter_table").rup_date();
$("#fVigenciaHasta004String_filter_table").rup_date();

jQuery.validator.addMethod("validacionFechas", function(value, element, params) {
	var fechaDesde=$("#fVigenciaDesde004String_filter_table").val();
	var fechaHasta=$("#fVigenciaHasta004String_filter_table").val();
	if(fechaDesde!=''&&fechaHasta!=''){
		fechaDesde=new Date(fechaDesde.substring(6,10),fechaDesde.substring(3,5),fechaDesde.substring(0,2));
		fechaHasta=new Date(fechaHasta.substring(6,10),fechaHasta.substring(3,5),fechaHasta.substring(0,2));
		if(fechaDesde>fechaHasta){
			return false;
		}else{
			return true;
		}
	}else{
		return true;
	}
});

$("#fVigenciaDesde004String_detail_table").rup_date();
$("#fVigenciaHasta004String_detail_table").rup_date();

jQuery.validator.addMethod("validacionFechasDetalle", function(value, element, params) {
	var fechaDesde=$("#fVigenciaDesde004String_detail_table").val();
	var fechaHasta=$("#fVigenciaHasta004String_detail_table").val();
	if(fechaDesde!=''&&fechaHasta!=''){
		fechaDesde=new Date(fechaDesde.substring(6,10),fechaDesde.substring(3,5),fechaDesde.substring(0,2));
		fechaHasta=new Date(fechaHasta.substring(6,10),fechaHasta.substring(3,5),fechaHasta.substring(0,2));
		if(fechaDesde>fechaHasta){
			return false;
		}else{
			return true;
		}
	}else{
		return true;
	}
});

jQuery.validator.addMethod("validacionDelegado", function(value, element, params) {
	var fechaDesde=$("#fVigenciaDesde004String_detail_table").val();
	var fechaHasta=$("#fVigenciaHasta004String_detail_table").val();
	var delegadoCorrecto=false;
	var texto=$("#ui-dialog-title-Firmantes_detail_div").html();
	var id=0;
	if(texto=="Agregar registro"||texto=="Gehitu erregistroa"){
		id=0;
	}else{
		id=$("#id004").val();
	}
	
	if(($("#id003Cargo_detail_table").find('option:selected').text().indexOf('Deleg')>-1 || $("#id003Cargo_detail_table").find('option:selected').text().indexOf('Ordez')>-1)    
			&& $("#idProv004_detail_table").val()!=''){
		//tenemos que buscar que no haya otro delegado vigente en esas fecha para esa provincia
		var urlCarga ="/ab03bRERAWar/ab03b04t00/buscarDelegadoVigente";
		$.rup_ajax({
	    	url: urlCarga,
	    	dataType: 'json',
	    	data:{'provincia':$("#idProv004_detail_table").val(), 'desde':$("#fVigenciaDesde004String_detail_table").val(),'hasta':$("#fVigenciaHasta004String_detail_table").val(),'id':id},
	    	cache: false,
	    	type: "GET",
	    	contentType: 'application/json',
	    	async:false,
	    	success: function (xhr, ajaxOptions) {
	    		if(xhr.valor!="0"){
	    			delegadoCorrecto= false;;
	    		}else{
	    			delegadoCorrecto= true;
	    		}
	    	}
	    });
	}else{
		return true;
	}
	if(!delegadoCorrecto){
		return false;
	}else{
		return true;
	}
});

jQuery.validator.addMethod("tipoDocumento", function(value, element, params) {
	var elegido=$("#tipoDoc044_detail_table option:selected").text();
	elegido=elegido.toUpperCase();

	params=elegido;
	if(elegido.indexOf("DNI")>-1){
		return dniMio(value);
	}else if(elegido.indexOf("CIF")>-1){
		return cif(value);
	}else if(elegido.indexOf("NIF")>-1){
		return nif(value);
	}else if(elegido.indexOf("NIE")>-1){
		return validarNie(value);
	}
	return true;
});

$("#Firmantes").on("jqGridAddEditAfterShowForm", function(event,savedData, newData){
	$("#pag_Firmantes").css("display",'none');
	var texto=$("#ui-dialog-title-Firmantes_detail_div").html();
	
	$("#id004_detail_table").attr("disabled",true);
});

//Funcion limpiar
$('#Firmantes_filter_cleanLink').click(function(event){
	resetFiltro($("#Firmantes_filter_form"));
	
	//se borran los mensajes de errores que se muestran en el feedback
	$("#Firmantes_filter_form").validate().submitted = {};
	//se cierra el feedback
	$("#Firmantes_feedback").rup_feedback("close");
	
	$("#Firmantes").rup_table('filter'); 
	
	// se quitan las imagenes que marcan el error
	$(".rup-maint_validateIcon", $("#Firmantes_filter_form")).remove();
});

function dniMio(value){
	value = value.toUpperCase().replace(/\s/, '');
	if (value.length === 9) {
		var dni_letters = "TRWAGMYFPDXBNJZSQVHLCKE";
	    var letter = dni_letters.charAt( parseInt( value, 10 ) % 23 );
	    
	    return letter == value.charAt(8);
		
	} else {
		return false;
	}
}

function pasaporte(value){
	var regsaid = /^[A-PR-WY][1-9]\d\s?\d{4}[1-9]$/ig;
	 
    if(regsaid.test(value) == false)
    {
       return false;
    }
    return true;
}

function cif(value){
	par = 0; 
	non = 0; 
	letras = "ABCDEFGHKLMNPQS"; 
	let = value.charAt(0);   
	if (value.length!=9) { 
		//alert('El Cif debe tener 9 d?gitos'); 
		return false; 
	}   
	if (letras.indexOf(let.toUpperCase())==-1) { 
		//alert("El comienzo del Cif no es v?lido"); 
		return false; 
	}   
	for (zz=2;zz<8;zz+=2) 
	{ 
		par = par+parseInt(value.charAt(zz)); 
	}   
	for (zz=1;zz<9;zz+=2) 
	{ 
		nn = 2*parseInt(value.charAt(zz)); 
		if (nn > 9) 
			nn = 1+(nn-10); 
		non = non+nn; 
	}   
	parcial = par + non; 
	control = (10 - ( parcial % 10)); 
	if (control==10) control=0;   
	if (control!=value.charAt(8)) { 
		//alert("El Cif no es v?lido"); 
		return false; 
	} 
	//alert("El Cif es v?lido"); 
	return true;
}

function nif(value){
	var nie_prefix = value.charAt( 0 );

    switch (nie_prefix) {
      case 'X': nie_prefix = 0; break;
      case 'Y': nie_prefix = 1; break;
      case 'Z': nie_prefix = 2; break;
    }

    return dniMio( nie_prefix + value.substr(1) );
}

function validarNie(nie) {
	nie = nie.toUpperCase();
	 
	if (!nie.match('((^[A-Z]{1}[0-9]{7}[A-Z0-9]{1}$|^[T]{1}[A-Z0-9]{8}$)|^[0-9]{8}[A-Z]{1}$)')) {
		return false;
	}
	 
	if (/^[T]{1}/.test(nie)) {
		return (nie[8] === /^[T]{1}[A-Z0-9]{8}$/.test(nie));
	}
	 
	if (/^[XYZ]{1}/.test(nie)) {
		return (
				nie[8] === "TRWAGMYFPDXBNJZSQVHLCKE".charAt(
				nie.replace('X', '0')
				.replace('Y', '1')
				.replace('Z', '2')
				.substring(0, 8) % 23
	   ));
	}
	 
	return false;
}